<?php
require_once __DIR__ . '/../includes/auth.php';
require_role(['admin']);
require_once __DIR__ . '/../includes/db.php';
// Filters
$where = [];$params = [];
if (!empty($_GET['status'])) { $where[] = 'c.status = ?'; $params[] = $_GET['status']; }
if (!empty($_GET['package_id'])) { $where[] = 'c.package_id = ?'; $params[] = (int)$_GET['package_id']; }
if (!empty($_GET['city'])) { $where[] = 'c.city LIKE ?'; $params[] = '%'.$_GET['city'].'%'; }
$q = 'SELECT c.*, p.name as package_name FROM customers c LEFT JOIN packages p ON c.package_id=p.id';
if ($where) $q .= ' WHERE ' . implode(' AND ', $where);
$stmt = $pdo->prepare($q);
$stmt->execute($params);
$rows = $stmt->fetchAll();
$packages = $pdo->query('SELECT * FROM packages')->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Customers</title></head><body>
<h1>Customers</h1>
<form method="get">
  Status: <select name="status"><option value="">--</option><option value="waiting">Waiting</option><option value="approved">Approved</option><option value="active">Active</option></select>
  Paket: <select name="package_id"><option value="">--</option><?php foreach($packages as $p) echo '<option value="'.(int)$p['id'].'">'.htmlspecialchars($p['name']).'</option>';?></select>
  Kota: <input name="city">
  <button>Filter</button>
</form>
<p><a href="export_excel.php">Export Excel</a> | <a href="export_pdf.php">Export PDF</a></p>
<table border="1" cellpadding="6"><tr><th>ID</th><th>Nama</th><th>Paket</th><th>Status</th><th>Aksi</th></tr>
<?php foreach($rows as $r){ echo '<tr><td>'.$r['id'].'</td><td>'.htmlspecialchars($r['full_name']).'</td><td>'.htmlspecialchars($r['package_name']).'</td><td>'.$r['status'].'</td><td><a href="customer_view.php?id='.$r['id'].'">Lihat</a></td></tr>'; } ?>
</table>
</body></html>
